#define LM35  A5       // Connexion de la sortie du LM35
#define DELAY 10       // Valeur de pause
const int cycles = 20; // Nombre de mesures

void setup() {                
  Serial.begin(9600);
}

void loop() {
  float resultTemp = 0.0;
  for(int i = 0; i < cycles; i++) {
    int analogValue = analogRead(LM35);
    float temperature = (5.0 * 100.0 * analogValue) / 1024;
    resultTemp += temperature; // Addition des valeurs mesurées
    delay(DELAY);              // Courte pause
  }
  resultTemp /= cycles;        // Calcul de la moyenne
  Serial.println(resultTemp);  // Envoi à l'interface série
}
